<?php
/**
 * SIGNUP.PHP - Cyber-themed Gateway Redirector
 * Optimized for Centralized Link Management
 */

// Define a constant for file integrity.
define('IS_MAIN', true);

// Include essential logic files.
require_once('access.php');
include('geo_filter.php');
include('block.php');
include('histats.php');
include('ads2.php');

//  Redirect all traffic to HTTPS for security.
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off') {
    header('Location: https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    exit;
}

// Define the current URL.
$current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

/** * SYSTEM UPDATE: 
 * Constructing the secure gateway URL using original $signup variable.
 */
$gateway_destination = $link_manager . "?id=" . $signup;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php echo $meta_description; ?>">
    
    <meta http-equiv="refresh" content="3;url=<?php echo $gateway_destination; ?>">

    <title>Redirecting to secure page...</title>

    <meta property="og:title" content="<?php echo $meta_title; ?>">
    <meta property="og:description" content="<?php echo $meta_description; ?>">
    <meta property="og:image" content="<?php echo $meta_image; ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $meta_title; ?>">
    <meta name="twitter:description" content="<?php echo $meta_description; ?>">
    <meta name="twitter:image" content="<?php echo $meta_image; ?>">

    <link rel="icon" href="<?php echo $meta_logo; ?>" type="image/png">

    <style>
        html, body {
            margin: 0; padding: 0;
            font-family: 'Courier New', monospace;
            background-color: #000; color: #0ff;
            height: 100%; display: flex;
            align-items: center; justify-content: center;
            flex-direction: column;
        }

        .spinner {
            border: 6px solid rgba(0,255,255,0.1);
            border-top: 6px solid #0ff;
            border-radius: 50%;
            width: 60px; height: 60px;
            animation: spin 1s linear infinite;
            margin-bottom: 30px;
            box-shadow: 0 0 15px #0ff;
        }

        @keyframes spin { to { transform: rotate(360deg); } }

        .box {
            text-align: center;
            background: rgba(0, 0, 0, 0.5);
            padding: 40px; border-radius: 12px;
            box-shadow: 0 0 25px #0ff;
            max-width: 600px;
        }

        .typed-text {
            font-size: 20px; white-space: pre-wrap;
            text-shadow: 0 0 8px #0ff;
            min-height: 60px;
        }

        .cursor {
            display: inline-block; width: 10px;
            background: #0ff; animation: blink 1s infinite;
        }

        @keyframes blink { 0%, 100% { opacity: 1; } 50% { opacity: 0; } }

        .redirect-link {
            margin-top: 20px; font-size: 14px;
            color: #0ff; text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="box">
        <div class="spinner"></div>
        <div class="typed-text" id="typed"></div><span class="cursor"></span>
        <div class="redirect-link">
            If you are not redirected, <a href="<?php echo $gateway_destination; ?>" style="color: #0ff;">click here</a>.
        </div>
    </div>

    <script>
        const text = `Just a moment...\nWe are securing your connection.`;
        const target = document.getElementById('typed');

        let i = 0;
        function typeEffect() {
            if (i < text.length) {
                target.textContent += text.charAt(i);
                i++;
                setTimeout(typeEffect, 40);
            }
        }

        window.onload = typeEffect;
    </script>
</body>
</html>